package signature

import (
	"crypto"
	"crypto/rsa"
	"crypto/sha256"
	"crypto/x509"
	"encoding/base64"
	"encoding/pem"
	"io/ioutil"
	"log"
	"strings"
)

func CheckSignatureString(signatureString string) (bool, string) {
	splitted := strings.Split(strings.TrimSpace(signatureString), "$")
	if len(splitted) != 2 {
		return false, ""
	}
	msg := splitted[0]
	sign, err := base64.StdEncoding.DecodeString(splitted[1])
	if err != nil {
		return false, ""
	}

	publicKeyPEM, err := ioutil.ReadFile("signature/public.pem")
	if err != nil {
		log.Println("Reading key failed")
		return false, ""
	}

	block, _ := pem.Decode(publicKeyPEM)
	publicKey, err := x509.ParsePKCS1PublicKey(block.Bytes)
	if err != nil {
		log.Println("Parsing key failed")
		return false, ""
	}

	hasher := sha256.New()
	_, err = hasher.Write([]byte(msg))
	if err != nil {
		log.Println("hashing failed")
		return false, ""
	}
	msgHash := hasher.Sum(nil)

	err = rsa.VerifyPSS(publicKey, crypto.SHA256, msgHash, []byte(sign), nil)
	if err != nil {
		log.Printf("%v\n", err)
		return false, ""
	}

	return true, msg
}
